/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.mcsp.model.McSpNote;
import net.raphimc.noteblocklib.format.mcsp.model.McSpSong;
import net.raphimc.noteblocklib.model.Note;

public class McSpIo {
    private static final int BUFFER_SIZE = 0x100000;

    public static McSpSong readSong(InputStream is, String fileName) {
        Scanner scanner = new Scanner((InputStream)new BufferedInputStream(is, 0x100000), StandardCharsets.ISO_8859_1.name()).useDelimiter("\\|");
        McSpSong song = new McSpSong(fileName);
        scanner.nextInt();
        Map<Integer, McSpNote[]> notes = song.getMcSpNotes();
        int tick = 0;
        while (scanner.hasNext()) {
            tick += scanner.nextInt();
            char[] noteData = scanner.next().toCharArray();
            if (noteData.length != 14) {
                throw new IllegalArgumentException("Invalid note data: " + new String(noteData));
            }
            McSpNote[] noteArray = new McSpNote[7];
            for (int i = 0; i < noteArray.length; ++i) {
                int instrument = noteData[i * 2] - 48;
                int key = noteData[i * 2 + 1] - 65;
                if (instrument == 0) continue;
                McSpNote note = new McSpNote();
                note.setInstrument((byte)(instrument - 1));
                note.setKey((byte)key);
                noteArray[i] = note;
            }
            notes.put(tick, noteArray);
        }
        song.getTempoEvents().set(0, 10.0f);
        for (Map.Entry<Integer, McSpNote[]> entry : notes.entrySet()) {
            for (McSpNote mcSpNote : entry.getValue()) {
                if (mcSpNote == null) continue;
                Note note = new Note();
                note.setInstrument(MinecraftInstrument.fromNbsId(mcSpNote.getInstrument()));
                note.setMcKey(mcSpNote.getKey());
                song.getNotes().add((int)entry.getKey(), note);
            }
        }
        return song;
    }
}

